package com.example.sefinsa_app.ui.clientes.crear;

import static com.example.sefinsa_app.utilities.BluetoothUtils.context;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigation;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosFragment;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesFotosDialogFragment;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesFotosFragment;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ClientesCrearFragment extends Fragment
        implements ClientesFotosFragment.OnPhotosSelectedListener, AvalesFotosFragment.OnPhotosSelectedListener {

    private static final Logger log = LoggerFactory.getLogger(ClientesCrearFragment.class);
    private ClientesCrearViewModel mViewModel;

    private Button btnRegistrarCliente, btnUbicacion, btnSubirFotos, btnSubirFotosAval, btnUbicacionAval;

    private TextInputLayout tlNombreCliente, tlTelefono, tlDireccion, tlRuta, tlPoblacion, tlColocadora, tlOtrasReferencias,
            tlGarantias, tlNombreGrupo, tlNombreAval, tlTelefonoAval, tlDireccionAval,
            tlOtrasReferenciasAval,tlGarantiasAval;;

    private AutoCompleteTextView rutasAutoCompleteTextView,
            poblacionesAutoCompleteTextView, colocadorasAutoCompleteTextView, avalesAutoCompleteTextView, avalesAutoCompleteTextViewNuevo;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;

    private String cliente_id = "", ruta_id = "", poblacion_id = "", colocadora_id = "", ruta_idAval = "", poblacion_idAval = "", colocadora_idAval = "", aval_id = "";

    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private String selectedAval = "";
    private SharedPreferences sesion;
    private HashMap<String, String> avalMap;
    private ArrayList<String> pathsGarantiasCliente;
    private ArrayList<String> pathsComprobantesCliente;
    private ArrayList<String> pathsFotoCliente;
    private ArrayList<String> pathsIneCliente;
    private ArrayList<String> pathsFachadaCliente;
    private ArrayList<String> pathsContratoCliente;

    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private ArrayList<String> pathsFotoAval;
    private ArrayList<String> pathsIneAval;
    private ArrayList<String> pathsFachadaAval;

    List<MultipartBody.Part> archivosGeneral;
    List<MultipartBody.Part> archivosGeneralAval;

    FusedLocationProviderClient client;
    private int previousLengthCliente, previousLengthAval;
    private boolean backSpaceCliente, backSpaceAval;

    String lat = "";
    String lgt = "";
    String latAval = "";
    String lgtAval = "";

    public static ClientesCrearFragment newInstance() {
        return new ClientesCrearFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_clientes_crear, container, false);
    }


    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setHasOptionsMenu(true);

    }
    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesCliente2,
                                 ArrayList<String> pathsGarantiasCliente2,
                                 ArrayList<String> pathsIneCliente2,
                                 ArrayList<String> pathsFotoCliente2,
                                 ArrayList<String> pathsContratoCliente2,
                                 ArrayList<String> pathsFachadaCliente2,
                                 List<MultipartBody.Part> archivosGeneral2) {

        // Imprimir los nombres o rutas de los archivos en los ArrayList
        Log.d("LOG_PHOTOS", "onPhotosSelected pathsComprobantesCliente2: " + pathsComprobantesCliente2.toString());
        Log.d("LOG_PHOTOS", "onPhotosSelected pathsContratoCliente2: " + pathsContratoCliente2.toString());
        Log.d("LOG_PHOTOS", "onPhotosSelected pathsGarantiasCliente: " + pathsGarantiasCliente2.toString());
        Log.d("LOG_PHOTOS", "onPhotosSelected pathsIneCliente: " + pathsIneCliente2.toString());
        Log.d("LOG_PHOTOS", "onPhotosSelected pathsFotoCliente: " + pathsFotoCliente2.toString());
        Log.d("LOG_PHOTOS", "onPhotosSelected pathsFachadaCliente: " + pathsFachadaCliente2.toString());
        Log.d("LOG_PHOTOS", "onPhotosSelected archivosGeneral2: " + archivosGeneral2.toString());

        // Inicializar y limpiar las listas si es necesario
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<>();
        }
        this.archivosGeneral.addAll(archivosGeneral2);

        // Verificar que los datos se han copiado correctamente
        Log.d("LOG_PHOTOS", "this.archivosGeneral: " + this.archivosGeneral.toString());
        for (MultipartBody.Part part : archivosGeneral) {
            Log.d("DEBUG_ARCHIVOS", "this.archivosGeneral Archivo en archivosGeneral: " + part.toString());
        }

        for (String path : pathsContratoCliente2) {
            File file = new File(path);
            Log.d("DEBUG_ARCHIVOS", "this.archivosGeneral Archivo: " + path + " - Existe: " + file.exists() + " - Tamaño: " + file.length());
        }


        if (this.pathsComprobantesCliente == null) {
            this.pathsComprobantesCliente = new ArrayList<>();
        }
        this.pathsComprobantesCliente.clear();

        if (this.pathsGarantiasCliente == null) {
            this.pathsGarantiasCliente = new ArrayList<>();
        }
        this.pathsGarantiasCliente.clear();

        if (this.pathsIneCliente == null) {
            this.pathsIneCliente = new ArrayList<>();
        }
        this.pathsIneCliente.clear();

        if (this.pathsFotoCliente == null) {
            this.pathsFotoCliente = new ArrayList<>();
        }
        this.pathsFotoCliente.clear();

        if (this.pathsFachadaCliente == null) {
            this.pathsFachadaCliente = new ArrayList<>();
        }
        this.pathsFachadaCliente.clear();

        if (this.pathsContratoCliente == null) {
            this.pathsContratoCliente = new ArrayList<>();
        }
        this.pathsContratoCliente.clear();

        // Agregar archivos de las diferentes listas a pathsComprobantesAval

        if (pathsIneCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsIneCliente2);
        }
        if (pathsComprobantesCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsComprobantesCliente2);
        }
        if (pathsFotoCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsFotoCliente2);
        }
        if (pathsContratoCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsContratoCliente2);
        }
        if (pathsFachadaCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsFachadaCliente2);
        }
        if (pathsGarantiasCliente2 != null) {
            this.pathsGarantiasCliente.addAll(pathsGarantiasCliente2);
        }

        Log.d("log", "Total de archivos en archivosGeneral: " + archivosGeneral.size());
    }

    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesAval2,
                                 ArrayList<String> pathsGarantiasAval2,
                                 ArrayList<String> pathsIneAval2,
                                 ArrayList<String> pathsFotoAval2,
                                 ArrayList<String> pathsFachadaAval2,
                                 List<MultipartBody.Part> archivosGeneral2) {


        // Inicializar y limpiar las listas si es necesario
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<>();
        }
        this.archivosGeneral.addAll(archivosGeneral2);

        // Verificar que los datos se han copiado correctamente
        Log.d("LOG_PHOTOS", "this.archivosGeneral AVAL: " + this.archivosGeneral.toString());

        if (this.pathsComprobantesAval == null) {
            this.pathsComprobantesAval = new ArrayList<>();
        }
        this.pathsComprobantesAval.clear();

        if (this.pathsGarantiasAval == null) {
            this.pathsGarantiasAval = new ArrayList<>();
        }
        this.pathsGarantiasAval.clear();

        if (this.pathsIneAval == null) {
            this.pathsIneAval = new ArrayList<>();
        }
        this.pathsIneAval.clear();

        if (this.pathsFotoAval == null) {
            this.pathsFotoAval = new ArrayList<>();
        }
        this.pathsFotoAval.clear();

        if (this.pathsFachadaAval == null) {
            this.pathsFachadaAval = new ArrayList<>();
        }
        this.pathsFachadaAval.clear();

        // Agregar archivos de las diferentes listas a pathsComprobantesAval

        if (pathsIneAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsIneAval2);
        }
        if (pathsComprobantesAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsComprobantesAval2);
        }
        if (pathsFotoAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFotoAval2);
        }
        if (pathsFachadaAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFachadaAval2);
        }
        if (pathsGarantiasAval2 != null) {
            this.pathsGarantiasAval.addAll(pathsGarantiasAval2);
        }

        Log.d("log", "Total de archivos en archivosGeneral: " + archivosGeneral.size());
    }

    private Bitmap makeMutable(Bitmap bitmap) {
        return bitmap.copy(Bitmap.Config.ARGB_8888, true);
    }


    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float bitmapRatio = (float) width / (float) height;

        if (bitmapRatio > 1) {
            width = maxSize;
            height = (int) (width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int) (height * bitmapRatio);
        }

        Bitmap resizedBitmap = Bitmap.createScaledBitmap(bitmap, width, height, true);
        addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }
    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG , 90, fos);
        fos.flush();
        fos.close();
        return file;
    }
    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }
    private void addDateTimeToBitmap(Bitmap bitmap) {
        // Asegurarse de que el bitmap sea mutable
        Bitmap mutableBitmap = makeMutable(bitmap);

        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(mutableBitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, mutableBitmap.getHeight() - 40, mutableBitmap.getWidth(), mutableBitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE); // Color del texto
        textPaint.setTextSize(18); // Tamaño del texto
        textPaint.setAntiAlias(true); // Suavizar el texto

        float x = 10;
        float y = mutableBitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        Bundle bundle = this.getArguments();

        client = LocationServices
                .getFusedLocationProviderClient(
                        getActivity());

        initElements(view);

        /**
         *  RUTAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        colocadoras = new ArrayList<Colocadora>();

        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                if (poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    poblacionesAutoCompleteTextView.setText("");
                }
                if (colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

            }
        });

        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */

        if (poblaciones.size() == 0) {
            getPoblaciones(ruta_id);
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();

                if (colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Colocadora> colocadorasFiltro =
                        colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(poblacion_id))
                                .collect(Collectors.toList());

                colocadorasAdapter = new ArrayAdapter<Colocadora>(requireActivity(), android.R.layout.simple_dropdown_item_1line, colocadorasFiltro);
                colocadorasAutoCompleteTextView.setThreshold(1);
                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);
            }
        });

        /**
         *  COLOCADORAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        if (colocadoras.size() == 0) {
            getColocadoras();
        }

        colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {

                Colocadora colocadora = colocadorasAdapter.getItem(i);
                colocadora_id = colocadora.getId();

            }
        });

        rutasAutoCompleteTextView.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus && rutasAutoCompleteTextView.getText().toString().isEmpty()) {

                    poblacionesAdapter = null;
                    poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                    poblacionesAutoCompleteTextView.setThreshold(1);
                    poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                    colocadorasAdapter = null;
                    colocadorasAdapter = new ArrayAdapter<Colocadora>(requireActivity(), android.R.layout.simple_dropdown_item_1line, colocadoras);
                    colocadorasAutoCompleteTextView.setThreshold(1);
                    colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);

                }
            }
        });

        btnRegistrarCliente.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (cliente_id.equals("")) {
                    if (Validator.fieldValidation(tlNombreCliente, "Ingresa un nombre de cliente")
                            && Validator.fieldValidation(tlTelefono, "Ingresa un teléfono")
                            && Validator.fieldValidation(tlDireccion, "Ingresa una dirección")
                            && validarVariableGlobal(tlRuta, ruta_id, "Selecciona una ruta")
                            && validarVariableGlobal(tlPoblacion, poblacion_id, "Selecciona una población")
                            && validarVariableGlobal(tlColocadora, colocadora_id, "Selecciona una colocadora")
                            && Validator.fieldValidation(tlOtrasReferencias, "Ingresa otras referencias")
                            && Validator.fieldValidation(tlGarantias, "Ingresa otras garantías")
                    ) {
                        if (!tlNombreAval.getEditText().getText().toString().isEmpty() || tlNombreAval.getEditText().getText() != null) {
                            AvalController ac = new AvalController(getContext());
                            String avalId = ac.getAvalByNombre(tlNombreAval.getEditText().getText().toString().toUpperCase());
                            if (!avalId.isEmpty() || avalId != null) {
                                ClienteController cc = new ClienteController(getContext());
                                String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlNombreAval.getEditText().getText().toString().toUpperCase());
                                if (Objects.equals(prestaNombre, "1")) {
                                    AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                                    b.setTitle("Aviso");
                                    b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                    b.setPositiveButton("Aceptar", null);

                                    AlertDialog dialog = b.create();
                                    dialog.show();
                                } else {
                                    registrarClienteNuevo();
                                }
                            } else {
                                registrarClienteNuevo();
                            }
                        } else {
                            registrarClienteNuevo();
                        }
                    }
                } else {
                    String nombre = tlNombreCliente.getEditText().getText().toString();
                    new MaterialAlertDialogBuilder(requireActivity())
                            .setTitle("Aviso")
                            .setMessage("El cliente " + nombre + " ya fue registrado")
                            .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            })
                            .show();
                }
            }

        });

        btnSubirFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ClientesFotosDialogFragment dialogFragment = new ClientesFotosDialogFragment();

                Bundle args = new Bundle();

                getCurrentLocation("cliente");

                args.putString("cliente", ""); // Pasar un JSON vacío o nulo
                args.putString("clienteNombre", "Nuevo Aval"); // Puedes pasar un nombre predeterminado

                dialogFragment.setArguments(args);
                dialogFragment.show(getChildFragmentManager(), "ClientesFotosDialog");
            }
        });

        btnSubirFotosAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();

                Bundle args = new Bundle();
                if (avalMap == null || avalMap.isEmpty()) {
                    //Log.e("DATA_ENVIADA", "No hay datos del aval para enviar.");

                    getCurrentLocation("aval");

                    args.putString("aval", ""); // Pasar un JSON vacío o nulo
                    args.putString("avalNombre", "Nuevo Aval"); // Puedes pasar un nombre predeterminado
                }
                else
                {
                    //Log.e("DATA_ENVIADA", "SI hay datos del aval para enviar.");
                    String personJsonString = Utils.getGsonParser().toJson(avalMap);
                    String personJsonString3 = aval_id;
                    String personJsonString4 = "2";
                    args.putString("aval", personJsonString);
                    args.putString("avalId", personJsonString3);
                    args.putString("tipo", personJsonString4);
                }
                String nombreAval = tlNombreAval.getEditText().getText().toString().trim();
                Log.e("DATA_ENVIADA", "Datos de nombreAval..............................." + nombreAval);
                dialogFragment.setArguments(args);
                dialogFragment.show(getChildFragmentManager(), "AvalesFotosDialog");
            }
        });

        configurarAutoCompleteTextView();
        SQLiteDatabase db = new DatabaseHelper(requireContext()).getReadableDatabase();

        // Llenar el AutoCompleteTextView
        llenarAutoComplete(db);
    }
    public static boolean validarVariableGlobal(TextInputLayout textInputLayout, String variableGlobal, String errorMessage) {
        if (variableGlobal == null || variableGlobal.isEmpty()) {
            textInputLayout.setError(errorMessage);
            return false;
        }
        textInputLayout.setError(null);
        return true;
    }

    private void initElements(View view) {

        CurrentFragment.fragment = "ClientesCrearFragment";

        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        poblacionesAutoCompleteTextView = view.findViewById(R.id.acPoblacion);
        colocadorasAutoCompleteTextView = view.findViewById(R.id.acColocadora);
        tlNombreCliente = view.findViewById(R.id.tlNombreCliente);
        avalesAutoCompleteTextView = view.findViewById(R.id.acCrearNombreCliente);
        avalesAutoCompleteTextViewNuevo = view.findViewById(R.id.acNombreAval);

        tlTelefono = view.findViewById(R.id.tlTelefono);
        tlDireccion = view.findViewById(R.id.tlDireccion);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlPoblacion = view.findViewById(R.id.tlPoblacion);
        tlColocadora = view.findViewById(R.id.tlColocadora);
        tlOtrasReferencias = view.findViewById(R.id.tlOtrasReferencias);
        tlGarantias = view.findViewById(R.id.tlGarantias);

        tlNombreAval = view.findViewById(R.id.tlNombreAval);

        tlTelefonoAval = view.findViewById(R.id.tlTelefonoAval);
        tlDireccionAval = view.findViewById(R.id.tlDireccionAval);
        tlOtrasReferenciasAval = view.findViewById(R.id.tlOtrasReferenciasAval);
        tlGarantiasAval = view.findViewById(R.id.tlGarantiasAval);

        btnRegistrarCliente = view.findViewById(R.id.btnRegistrarCliente);

        btnSubirFotos = view.findViewById(R.id.btnSubirFotos);
        btnSubirFotosAval = view.findViewById(R.id.btnSubirFotosAval);

        btnUbicacion = view.findViewById(R.id.btnUbicacion);
        btnUbicacionAval = view.findViewById(R.id.btnUbicacionAval);

        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        colocadoraController = new ColocadoraController(getActivity());
        clienteController = new ClienteController(getActivity());

        pathsGarantiasCliente = new ArrayList<>();
        pathsComprobantesCliente = new ArrayList<>();
        pathsIneCliente = new ArrayList<>();
        pathsFotoCliente = new ArrayList<>();
        pathsContratoCliente = new ArrayList<>();
        pathsFachadaCliente = new ArrayList<>();

        pathsGarantiasAval = new ArrayList<>();
        pathsComprobantesAval = new ArrayList<>();
        pathsIneAval = new ArrayList<>();
        pathsFotoAval = new ArrayList<>();
        pathsFachadaAval = new ArrayList<>();

        archivosGeneral = new ArrayList<>();

        btnUbicacion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getCurrentLocation("cliente");
                btnUbicacion.setText("Ubicación obtenida");
                Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
            }
        });

        btnUbicacionAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getCurrentLocation("aval");
                btnUbicacionAval.setText("Ubicación obtenida");
                Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
            }
        });
    }

    @SuppressLint("MissingPermission")
    private void getCurrentLocation(String rol) {
        LocationManager locationManager = (LocationManager)getActivity().getSystemService(Context.LOCATION_SERVICE);

        if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(@NonNull Task<Location> task) {
                            Location location = task.getResult();

                            if (location != null) {
                                if (rol.equals("cliente")) {
                                    lat = String.valueOf(location.getLatitude());
                                    lgt = String.valueOf(location.getLongitude());
                                    btnUbicacion.setText("Ubicación obtenida");
                                } else if (rol.equals("aval")) {
                                    latAval = String.valueOf(location.getLatitude());
                                    lgtAval = String.valueOf(location.getLongitude());
                                    btnUbicacionAval.setText("Ubicación obtenida");
                                }


                            } else {
                                // When location result is null
                                // initialize location request
                                LocationRequest locationRequest = new LocationRequest()
                                        .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(1000)
                                        .setNumUpdates(1);

                                LocationCallback locationCallback = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult)
                                    {
                                        Location location1 = locationResult.getLastLocation();

                                        if (Objects.equals(rol, "cliente")) {
                                            lat = String.valueOf(location1.getLatitude());
                                            lgt = String.valueOf(location1.getLongitude());
                                            btnUbicacion.setText("Ubicación obtenida");
                                        } else if (Objects.equals(rol, "aval")) {
                                            latAval = String.valueOf(location1.getLatitude());
                                            lgtAval = String.valueOf(location1.getLongitude());
                                            btnUbicacionAval.setText("Ubicación obtenida");
                                        }

                                    }
                                };

                                client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                            }
                        }
                    });
        } else {
            startActivity(new Intent(
                    Settings.ACTION_LOCATION_SOURCE_SETTINGS)
                    .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
        }
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }
    private List<Aval> obtenerListaAvales() {
        List<Aval> listaAvales = new ArrayList<>();
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        // Modifica la consulta SQL para incluir la condición
        String sqlQuery = "SELECT * FROM avales WHERE nombre_completo IS NOT NULL AND nombre_completo != '' ORDER BY nombre_completo ASC";
        Cursor cursor = db.rawQuery(sqlQuery, null);

        if (cursor != null && cursor.moveToFirst()) {
            do {
                Aval aval = new Aval(
                        cursor.getString(cursor.getColumnIndexOrThrow("id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                        cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                        cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                        cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id"))
                );
                listaAvales.add(aval);
            } while (cursor.moveToNext());

            cursor.close();
        }
        db.close();
        return listaAvales;
    }
    private void configurarAutoCompleteTextView() {
        new ObtenerClientesYAvalesTask().execute(); // Ejecuta la tarea asíncrona para obtener clientes y avales
    }

    private class ObtenerClientesYAvalesTask extends AsyncTask<Void, Void, List<Map<String, String>>> {
        @Override
        protected List<Map<String, String>> doInBackground(Void... voids) {
            DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            return getClientesYDisponibles(db);
        }

        @Override
        protected void onPostExecute(List<Map<String, String>> datos) {
            List<String> nombres = new ArrayList<>();
            Map<String, Map<String, String>> idMap = new HashMap<>();

            Log.d("DEBUG", "Datos obtenidos para llenar el AutoComplete del cliente: " + datos);

            for (Map<String, String> registro : datos) {
                String nombre = registro.get("nombre_completo");
                if (nombre != null && !nombre.trim().isEmpty()) {
                    nombres.add(nombre);
                    idMap.put(nombre, registro);
                }
            }

            ArrayAdapter<String> adapter = new ArrayAdapter<>(requireContext(), android.R.layout.simple_dropdown_item_1line, nombres);
            avalesAutoCompleteTextView.setAdapter(adapter);

            avalesAutoCompleteTextView.setOnItemClickListener((parent, view, position, id) -> {
                String nombreSeleccionado = (String) parent.getItemAtPosition(position);
                Map<String, String> seleccionado = idMap.get(nombreSeleccionado);

                if (seleccionado != null) {
                    String idSeleccionado = seleccionado.get("id");
                    String tipoSeleccionado = seleccionado.get("tipo");

                    DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
                    SQLiteDatabase db = dbHelper.getReadableDatabase();

                    if ("aval".equals(tipoSeleccionado)) {
                        aval_id = idSeleccionado;
                        llenarCamposClienteDesdeDB(db, idSeleccionado, tipoSeleccionado);
                    } else {
                        aval_id = "";
                        llenarCamposClienteDesdeDB(db, idSeleccionado, tipoSeleccionado);
                    }
                }
            });
        }
    }

    private void limpiarCampos() {
        aval_id = "";
        tlNombreCliente.getEditText().setText("");
        tlTelefono.getEditText().setText("");
        tlDireccion.getEditText().setText("");
        tlOtrasReferencias.getEditText().setText("");
        tlGarantias.getEditText().setText("");

        rutasAutoCompleteTextView.setText("", false);
        poblacionesAutoCompleteTextView.setText("", false);
        colocadorasAutoCompleteTextView.setText("", false);
    }

    private void llenarCamposAval(Aval aval) {
        if (aval != null) {
            // Llenar los campos con los datos del aval
            tlNombreCliente.getEditText().setText(aval.getNombre_completo());
            tlTelefono.getEditText().setText(aval.getTelefono());
            tlDireccion.getEditText().setText(aval.getDireccion());
            tlOtrasReferencias.getEditText().setText(aval.getOtras_referencias());
            tlGarantias.getEditText().setText(aval.getGarantias());

            // Seleccionar ruta en rutasAutoCompleteTextView
            if (aval.getRuta_id() != null) {
                for (int i = 0; i < rutas.size(); i++) {
                    if (rutas.get(i).getId().equals(aval.getRuta_id())) {
                        rutasAutoCompleteTextView.setText(rutas.get(i).toString(), false);
                        break;
                    }
                }
            }

            // Seleccionar población en poblacionesAutoCompleteTextView
            if (aval.getPoblacion_id() != null) {
                for (int i = 0; i < poblaciones.size(); i++) {
                    if (poblaciones.get(i).getId().equals(aval.getPoblacion_id())) {
                        poblacionesAutoCompleteTextView.setText(poblaciones.get(i).toString(), false);
                        break;
                    }
                }
            }

            // Seleccionar colocadora en colocadorasAutoCompleteTextView
            if (aval.getColocadora_id() != null) {
                for (int i = 0; i < colocadoras.size(); i++) {
                    if (colocadoras.get(i).getId().equals(aval.getColocadora_id())) {
                        colocadorasAutoCompleteTextView.setText(colocadoras.get(i).toString(), false);
                        break;
                    }
                }
            }
        }
    }


    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        List<Map<String, String>> clientes = new ArrayList<>();
        List<Map<String, String>> avales = new ArrayList<>();
        List<Map<String, String>> resultado = new ArrayList<>();

        // Consulta para obtener los clientes (excluyendo nombres nulos o vacíos)
        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo " +
                "FROM clientes " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }

        // Consulta para obtener los avales (excluyendo nombres nulos o vacíos)
        String queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo " +
                "FROM avales " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorAvales = db.rawQuery(queryAvales, null);
        if (cursorAvales != null) {
            while (cursorAvales.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }

        // Crear un Set para almacenar los nombres únicos y evitar duplicados
        Set<String> nombresUnicos = new HashSet<>();

        // Filtrar clientes que no están en avales
        Set<String> nombresAvales = new HashSet<>();
        for (Map<String, String> aval : avales) {
            nombresAvales.add(aval.get("nombre_completo"));
        }

        // Agregar clientes que no están en avales
        for (Map<String, String> cliente : clientes) {
            String nombreCliente = cliente.get("nombre_completo");
            if (!nombresAvales.contains(nombreCliente) && !nombresUnicos.contains(nombreCliente)) {
                resultado.add(cliente);
                nombresUnicos.add(nombreCliente); // Agregar al Set de nombres únicos
            }
        }

        // Agregar todos los avales, asegurando que no se repitan
        for (Map<String, String> aval : avales) {
            String nombreAval = aval.get("nombre_completo");
            if (!nombresUnicos.contains(nombreAval)) {
                resultado.add(aval);
                nombresUnicos.add(nombreAval); // Agregar al Set de nombres únicos
            }
        }

        // Log para depuración
        Log.d("DEBUG", "Clientes: " + clientes.size() + ", Avales: " + avales.size());
        Log.d("DEBUG", "Resultados combinados (filtrados): " + resultado.size());

        return resultado;
    }

    @SuppressLint("StaticFieldLeak")
    private void llenarAutoComplete(SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>() {
            @Override
            protected List<Map<String, String>> doInBackground(Void... voids) {
                return getClientesYDisponibles(db);
            }

            @Override
            protected void onPostExecute(List<Map<String, String>> datos) {
                List<String> nombres = new ArrayList<>();
                Map<String, Map<String, String>> idMap = new HashMap<>();

                Log.d("DEBUG", "Datos obtenidos para llenar el AutoComplete: " + datos);

                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre != null && !nombre.trim().isEmpty()) {
                        nombres.add(nombre);
                        idMap.put(nombre, registro);
                    }
                }

                ArrayAdapter<String> adapter = new ArrayAdapter<>(requireContext(), android.R.layout.simple_dropdown_item_1line, nombres);
                avalesAutoCompleteTextViewNuevo.setAdapter(adapter);

                avalesAutoCompleteTextViewNuevo.setOnItemClickListener((parent, view, position, id) -> {
                    if (!tlNombreAval.getEditText().getText().toString().isEmpty() || tlNombreAval.getEditText().getText() != null) {
                        AvalController ac = new AvalController(getContext());
                        String avalId = ac.getAvalByNombre(tlNombreAval.getEditText().getText().toString().toUpperCase());
                        if (!avalId.isEmpty() || avalId != null) {
                            ClienteController cc = new ClienteController(getContext());
                            String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlNombreAval.getEditText().getText().toString().toUpperCase());
                            if (Objects.equals(prestaNombre, "1")) {
                                AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                                b.setTitle("Aviso");
                                b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                b.setPositiveButton("Aceptar", null);

                                tlNombreAval.getEditText().setText("");

                                AlertDialog dialog = b.create();
                                dialog.show();
                            } else {
                                String nombreSeleccionado = (String) parent.getItemAtPosition(position);
                                Map<String, String> seleccionado = idMap.get(nombreSeleccionado);

                                if (seleccionado != null) {
                                    String idSeleccionado = seleccionado.get("id");
                                    String tipoSeleccionado = seleccionado.get("tipo");

                                    if ("aval".equals(tipoSeleccionado)) {
                                        verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                    } else {
                                        aval_id = "";
                                        llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                    }
                                }
                            }
                        } else {
                            String nombreSeleccionado = (String) parent.getItemAtPosition(position);
                            Map<String, String> seleccionado = idMap.get(nombreSeleccionado);

                            if (seleccionado != null) {
                                String idSeleccionado = seleccionado.get("id");
                                String tipoSeleccionado = seleccionado.get("tipo");

                                if ("aval".equals(tipoSeleccionado)) {
                                    verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                } else {
                                    aval_id = "";
                                    llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                }
                            }
                        }
                    } else {
                        String nombreSeleccionado = (String) parent.getItemAtPosition(position);
                        Map<String, String> seleccionado = idMap.get(nombreSeleccionado);

                        if (seleccionado != null) {
                            String idSeleccionado = seleccionado.get("id");
                            String tipoSeleccionado = seleccionado.get("tipo");

                            if ("aval".equals(tipoSeleccionado)) {
                                verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                            } else {
                                aval_id = "";
                                llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                            }
                        }
                    }
                });
            }
        }.execute();
    }

    @SuppressLint("StaticFieldLeak")
    private void verificarAvalAsync(SQLiteDatabase db, String idSeleccionado, String tipoSeleccionado) {
        new AsyncTask<Void, Void, String>() {
            @Override
            protected String doInBackground(Void... voids) {
                String nombreCliente = null;
                Cursor cursor = null;
                try {
                    String query = "SELECT clientes.nombre_completo FROM clientes INNER JOIN prestamos on clientes.id = prestamos.cliente_id WHERE prestamos.aval_id = ? AND prestamos.status='0'";
                    cursor = db.rawQuery(query, new String[]{idSeleccionado});

                    if (cursor != null && cursor.moveToFirst()) {
                        nombreCliente = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                    }
                } catch (Exception e) {
                    Log.e("DEBUG", "Error al verificar si el aval está asociado", e);
                } finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                return nombreCliente;
            }

            @Override
            protected void onPostExecute(String nombreCliente) {
                if (nombreCliente != null) {
                    new AlertDialog.Builder(getContext())
                            .setTitle("Aviso")
                            .setMessage("Este aval ya está ligado al cliente: " + nombreCliente + ". ¿Desea continuar?")
                            .setCancelable(false)
                            .setPositiveButton("Sí", (dialog, which) -> {
                                llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                aval_id = idSeleccionado;
                            })
                            .setNegativeButton("No", (dialog, which) -> {
                                dialog.dismiss();
                            })
                            .show();
                } else {
                    llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                }
            }
        }.execute();
    }
    @SuppressLint("StaticFieldLeak")
    private void llenarCamposAsync(SQLiteDatabase db, String id, String tipo) {
        new AsyncTask<Void, Void, Map<String, String>>() {
            @Override
            protected Map<String, String> doInBackground(Void... voids) {
                Map<String, String> resultado = new HashMap<>();
                String tabla = tipo.equals("cliente") ? "clientes" : "avales";
                String query = "SELECT id, direccion, telefono, garantias, otras_referencias, nombre_completo, " +
                        "carpeta_comprobantes, carpeta_garantias " +
                        "FROM " + tabla + " WHERE id = ?";

                Log.d("DEBUG", "Ejecutando query asincrónica para llenar campos: " + query);

                Cursor cursor = db.rawQuery(query, new String[]{id});
                if (cursor != null && cursor.moveToFirst()) {
                    resultado.put("id", cursor.getString(0));
                    resultado.put("direccion", cursor.getString(1));
                    resultado.put("telefono", cursor.getString(2));
                    resultado.put("garantias", cursor.getString(3));
                    resultado.put("otras_referencias", cursor.getString(4));
                    resultado.put("nombre_completo", cursor.getString(5));
                    resultado.put("carpeta_comprobantes", cursor.getString(6));
                    resultado.put("carpeta_garantias", cursor.getString(7));

                    aval_id = id; // Asignar aval_id

                    cursor.close();
                }

                return resultado;
            }

            @Override
            protected void onPostExecute(Map<String, String> resultado) {
                if (resultado != null && !resultado.isEmpty()) {
                    if (tipo.equals("cliente")) {
                        aval_id = "";
                        avalMap = null; // Reiniciar el HashMap si es cliente
                        Log.d("DEBUG", "Ejecutando query para llenar campos SIN AVAL: " + aval_id);
                    }
                    avalMap = (HashMap<String, String>) resultado; // Asignar al HashMap
                    selectedAval = id;  // Asignar el ID seleccionado

                    tlDireccionAval.getEditText().setText(resultado.get("direccion"));
                    tlTelefonoAval.getEditText().setText(resultado.get("telefono"));
                    tlGarantiasAval.getEditText().setText(resultado.get("garantias"));
                    tlOtrasReferenciasAval.getEditText().setText(resultado.get("otras_referencias"));

                    Log.d("DEBUG", "Contenido de avalMap: " + avalMap + " tipo: " + tipo);


                }
            }
        }.execute();
    }



    private void llenarCamposEnClientes(Cliente cliente) {
        if (cliente != null) {
            // Llenar los campos con los datos del aval
            tlNombreAval.getEditText().setText(cliente.getNombre_completo());
            tlTelefonoAval.getEditText().setText(cliente.getTelefono());
            tlDireccionAval.getEditText().setText(cliente.getDireccion());
            tlOtrasReferenciasAval.getEditText().setText(cliente.getOtras_referencias());
            tlGarantiasAval.getEditText().setText(cliente.getGarantias());
        }
    }

    private void limpiarCamposAval() {
        aval_id = "";
        tlNombreAval.getEditText().setText("");
        tlTelefonoAval.getEditText().setText("");
        tlDireccionAval.getEditText().setText("");
        tlOtrasReferenciasAval.getEditText().setText("");
        tlGarantiasAval.getEditText().setText("");
    }
    private void llenarCamposEnAvales(Aval aval) {
        if (aval != null) {
            aval_id = "";
            // Llenar los campos con los datos del aval
            tlNombreAval.getEditText().setText(aval.getNombre_completo());
            tlTelefonoAval.getEditText().setText(aval.getTelefono());
            tlDireccionAval.getEditText().setText(aval.getDireccion());
            tlOtrasReferenciasAval.getEditText().setText(aval.getOtras_referencias());
            tlGarantiasAval.getEditText().setText(aval.getGarantias());
        }
    }

    @SuppressLint("StaticFieldLeak")
    private void llenarCamposClienteDesdeDB(SQLiteDatabase db, String id, String tipo) {
        new AsyncTask<Void, Void, Map<String, String>>() {
            @Override
            protected Map<String, String> doInBackground(Void... voids) {
                Map<String, String> resultado = new HashMap<>();
                String tabla = tipo.equals("cliente") ? "clientes" : "avales";
                String query = "SELECT id, direccion, telefono, garantias, otras_referencias, nombre_completo, " +
                        "ruta_id, poblacion_id, colocadora_id " +
                        "FROM " + tabla + " WHERE id = ?";

                Log.d("DEBUG", "Ejecutando query para llenar campos del cliente: " + query);

                Cursor cursor = db.rawQuery(query, new String[]{id});
                if (cursor != null && cursor.moveToFirst()) {
                    resultado.put("id", cursor.getString(0));
                    resultado.put("direccion", cursor.getString(1));
                    resultado.put("telefono", cursor.getString(2));
                    resultado.put("garantias", cursor.getString(3));
                    resultado.put("otras_referencias", cursor.getString(4));
                    resultado.put("nombre_completo", cursor.getString(5));
                    resultado.put("ruta_id", cursor.getString(6));
                    resultado.put("poblacion_id", cursor.getString(7));
                    resultado.put("colocadora_id", cursor.getString(8));

                    cursor.close();
                }

                return resultado;
            }

            @Override
            protected void onPostExecute(Map<String, String> resultado) {
                if (resultado != null && !resultado.isEmpty()) {
                    // Llenar los campos del formulario del cliente
                    tlNombreCliente.getEditText().setText(resultado.get("nombre_completo"));
                    tlDireccion.getEditText().setText(resultado.get("direccion"));
                    tlTelefono.getEditText().setText(resultado.get("telefono"));
                    tlGarantias.getEditText().setText(resultado.get("garantias"));
                    tlOtrasReferencias.getEditText().setText(resultado.get("otras_referencias"));

                    // Seleccionar ruta en rutasAutoCompleteTextView
                    if (resultado.get("ruta_id") != null && rutas != null) {
                        for (int i = 0; i < rutas.size(); i++) {
                            if (rutas.get(i).getId().equals(resultado.get("ruta_id"))) {
                                rutasAutoCompleteTextView.setText(rutas.get(i).toString(), false);
                                ruta_id = rutas.get(i).getId();
                                break;
                            }
                        }
                    }

                    // Seleccionar población en poblacionesAutoCompleteTextView
                    if (resultado.get("poblacion_id") != null && poblaciones != null) {
                        for (int i = 0; i < poblaciones.size(); i++) {
                            if (poblaciones.get(i).getId().equals(resultado.get("poblacion_id"))) {
                                poblacionesAutoCompleteTextView.setText(poblaciones.get(i).toString(), false);
                                poblacion_id = poblaciones.get(i).getId();
                                break;
                            }
                        }
                    }

                    // Seleccionar colocadora en colocadorasAutoCompleteTextView
                    if (resultado.get("colocadora_id") != null && colocadoras != null) {
                        for (int i = 0; i < colocadoras.size(); i++) {
                            if (colocadoras.get(i).getId().equals(resultado.get("colocadora_id"))) {
                                colocadorasAutoCompleteTextView.setText(colocadoras.get(i).toString(), false);
                                colocadora_id = colocadoras.get(i).getId();
                                break;
                            }
                        }
                    }

                    Log.d("DEBUG", "Campos del cliente rellenados desde " + tipo + " con ID: " + id);
                }
            }
        }.execute();
    }

    private List<Cliente> obtenerListaClientes() {
        List<Cliente> listaClientes = new ArrayList<>();
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String sqlQuery = "SELECT * FROM clientes ORDER BY nombre_completo ASC";
        Cursor cursor = db.rawQuery(sqlQuery, null);

        if (cursor != null && cursor.moveToFirst()) {
            do {
                Cliente cliente = new Cliente(
                        cursor.getString(cursor.getColumnIndexOrThrow("id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                        cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                        cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                        cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("prestanombre"))
                );

                listaClientes.add(cliente);
            } while (cursor.moveToNext());

            cursor.close();
        } else {
            Log.d("SQLiteCliente", "No se encontraron clientes en la base de datos.");
        }

        db.close();
        return listaClientes;
    }

    private void getRutas() {
        if (rutaController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.requireActivity());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = (JSONArray) response.get("data");
                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    rutas.add(ruta);
                                    rutaController.nueva(ruta);
                                }

                                rutasAdapter = new ArrayAdapter<Ruta>(requireActivity(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, getActivity());
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        } else {
            rutas = rutaController.obtener();

            rutasAdapter = new ArrayAdapter<Ruta>(requireActivity(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.requireActivity());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = (JSONArray) response.get("data");
                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);
                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, getActivity());
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);
        }
    }

    private void getColocadoras() {
        if (colocadoraController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.requireActivity());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlColocadoras, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = (JSONArray) response.get("data");
                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Colocadora colocadora = gson.fromJson(obj.toString(), Colocadora.class);

                                    colocadoras.add(colocadora);
                                    colocadoraController.nueva(colocadora);
                                }

                                colocadorasAdapter = new ArrayAdapter<Colocadora>(requireActivity(), android.R.layout.simple_dropdown_item_1line, colocadoras);
                                colocadorasAutoCompleteTextView.setThreshold(1);
                                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, getActivity());
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            colocadoras = colocadoraController.obtener();

            colocadorasAdapter = new ArrayAdapter<Colocadora>(requireActivity(), android.R.layout.simple_dropdown_item_1line, colocadoras);
            colocadorasAutoCompleteTextView.setThreshold(1);
            colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);
        }
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(ClientesCrearViewModel.class);
        // TODO: Use the ViewModel
    }

    public byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream byteBuff = new ByteArrayOutputStream();

        ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        int nRead;
        byte[] data = new byte[16384];

        while ((nRead = is.read(data, 0, data.length)) != -1) {
            Log.d("BUFFER", String.valueOf(data[0]) + " | " + nRead);

            buffer.write(data, 0, nRead);
        }

        return buffer.toByteArray();
    }


    private void registrarClienteNuevo(){
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        HashSet<String> set = new HashSet<>(pathsComprobantesCliente);
        pathsComprobantesCliente.clear();
        pathsComprobantesCliente.addAll(set);

        HashSet<String> set2 = new HashSet<>(pathsGarantiasCliente);
        pathsGarantiasCliente.clear();
        pathsGarantiasCliente.addAll(set2);

        HashSet<String> setAval = new HashSet<>(pathsComprobantesAval);
        pathsComprobantesAval.clear();
        pathsComprobantesAval.addAll(setAval);

        HashSet<String> set2Aval = new HashSet<>(pathsGarantiasAval);
        pathsGarantiasAval.clear();
        pathsGarantiasAval.addAll(set2Aval);
        //////////////////////

        String nombre = tlNombreCliente.getEditText().getText().toString().trim();
        String nombreFormateado = nombre.replace("ñ", "n").replace("Ñ", "N").toUpperCase();

        String direccion = tlDireccion.getEditText().getText().toString();
        String telefono = tlTelefono.getEditText().getText().toString();
        String orCliente = tlOtrasReferencias.getEditText().getText().toString();
        String garantias = tlGarantias.getEditText().getText().toString();

        String nombreAval = tlNombreAval.getEditText().getText().toString().trim();
        String nombreAvalFormateado = nombreAval.replace("ñ", "n").replace("Ñ", "N").toUpperCase();
        String direccionAval = tlDireccionAval.getEditText().getText().toString();
        String telefonoAval = tlTelefonoAval.getEditText().getText().toString();
        String orAval = tlOtrasReferenciasAval.getEditText().getText().toString();
        String garantiasAval = tlGarantiasAval.getEditText().getText().toString();

        Log.d("ARCHIVOS", "CLIENTE nombre.......................................................: " + nombre);

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "createNuevoClienteConAvalAPP");
        RequestBody nombre_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), nombreFormateado);
        RequestBody direccion_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), tlDireccion.getEditText().getText().toString());
        RequestBody telefono_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), tlTelefono.getEditText().getText().toString());
        RequestBody or_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), tlOtrasReferencias.getEditText().getText().toString());
        RequestBody colocadoraId = RequestBody.create(MediaType.parse("multipart/form-data"), colocadora_id);
        RequestBody rutaId = RequestBody.create(MediaType.parse("multipart/form-data"), ruta_id);
        RequestBody poblacionId = RequestBody.create(MediaType.parse("multipart/form-data"), poblacion_id);
        RequestBody garantias_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), tlGarantias.getEditText().getText().toString());
        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasCliente.size()+"");
        RequestBody cantidad_archivos_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesCliente.size()+"");

        RequestBody latitud = RequestBody.create(MediaType.parse("multipart/form-data"), lat);
        RequestBody longitud = RequestBody.create(MediaType.parse("multipart/form-data"), lgt);

        RequestBody nombre_aval = RequestBody.create(MediaType.parse("multipart/form-data"), nombreAvalFormateado);
        RequestBody direccion_aval = RequestBody.create(MediaType.parse("multipart/form-data"), tlDireccionAval.getEditText().getText().toString());
        RequestBody telefono_aval = RequestBody.create(MediaType.parse("multipart/form-data"), tlTelefonoAval.getEditText().getText().toString());
        RequestBody or_aval = RequestBody.create(MediaType.parse("multipart/form-data"),  tlOtrasReferenciasAval.getEditText().getText().toString());
        RequestBody garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), tlGarantiasAval.getEditText().getText().toString());
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasAval.size()+"");
        RequestBody cantidad_archivos_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesAval.size()+"");
        RequestBody colocadoraIdAval = RequestBody.create(MediaType.parse("multipart/form-data"), colocadora_idAval);
        RequestBody rutaIdAval = RequestBody.create(MediaType.parse("multipart/form-data"), ruta_idAval);
        RequestBody poblacionIdAval = RequestBody.create(MediaType.parse("multipart/form-data"), poblacion_idAval);
        RequestBody latitudAval = RequestBody.create(MediaType.parse("multipart/form-data"), latAval);
        RequestBody longitudAval = RequestBody.create(MediaType.parse("multipart/form-data"), lgtAval);


        Log.d("DEBUG_ENVIO", "Total de archivos a enviar antes de subir: " + archivosGeneral.size());


        Call<ResponseMe> call = retrofitInterface.registrarCliente(archivosGeneral, func,nombre_cliente, direccion_cliente, telefono_cliente,
                or_cliente, garantias_cliente, rutaId, poblacionId, colocadoraId, cantidad_archivos_garantias_cliente, cantidad_archivos_cliente,
                nombre_aval, direccion_aval, telefono_aval, or_aval, garantias_aval, cantidad_archivos_garantias_aval, cantidad_archivos_aval, latitud, longitud,
                colocadoraIdAval, rutaIdAval, poblacionIdAval, latitudAval, longitudAval);

        String cantidadGarantias = String.valueOf(pathsGarantiasCliente.size());

        String cantidadGarantiasAval = String.valueOf(pathsGarantiasAval.size());
        String cantidadArchivosAval = String.valueOf(pathsComprobantesAval.size());


        String cantidadArchivos = String.valueOf(pathsComprobantesCliente.size());
        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {
                dialog.cancel();
                if (response.isSuccessful()) {
                    // Obtener el cliente ID de la respuesta
                    if (response.body() != null && response.body().getStatus().equals("success")) {
                        Log.d("response", response.body().getMessage());

                        //Toast.makeText(getActivity(), "El cliente y aval han sido registrados", Toast.LENGTH_LONG).show();

                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = getLayoutInflater();
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se registraron los datos correctamente."); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getActivity());
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);

                        String clienteIdR = response.body().getClienteId(); // Asegúrate de que este método exista en ResponseMe
                        String avalIdR = response.body().getAvalId(); // Asegúrate de que este método exista en ResponseMe

                        Log.d("response", "Cliente registrado EN SERVER con ID clienteIdR: " + clienteIdR);
                        Log.d("response", "Aval registrado EN SERVER con ID avalIdR: " + avalIdR);

                        // Verificar si el cliente ya existe en SQLite
                        if (!clienteExisteEnSQLite(nombreFormateado)) {

                            registrarClienteEnSQLite(
                                    archivosGeneral, nombreFormateado, direccion, telefono, orCliente, garantias,
                                    ruta_id, poblacion_id, colocadora_id, cantidadGarantias, cantidadArchivos, clienteIdR, avalIdR, "on"
                            );

                        } else {
                            Log.d("SQLite", "El cliente ya existe en SQLite.");
                        }

                        // Verificar si el aval ya existe en SQLite
                        if (!avalExisteEnSQLite(nombreAvalFormateado)) {
                            Log.d("SQLite", "ENTRO EN REGISTRAR AVAL.................");
                            registrarAvalEnSQLite(
                                    archivosGeneral, nombreAvalFormateado, direccionAval, telefonoAval, orAval, garantiasAval,
                                    ruta_id, poblacion_id, colocadora_id, cantidadGarantiasAval, cantidadArchivosAval, avalIdR, "on"
                            );

                        } else {
                            Log.d("SQLite", "El aval ya existe en SQLite.");
                        }

                        dialog.cancel();
                        tlNombreCliente.getEditText().setText("");
                        tlTelefono.getEditText().setText("");
                        tlDireccion.getEditText().setText("");
                        rutasAutoCompleteTextView.setText("");
                        poblacionesAutoCompleteTextView.setText("");
                        colocadorasAutoCompleteTextView.setText("");
                        tlOtrasReferencias.getEditText().setText("");
                        tlGarantias.getEditText().setText("");

                        tlNombreAval.getEditText().setText("");
                        tlTelefonoAval.getEditText().setText("");
                        tlDireccionAval.getEditText().setText("");
                        tlOtrasReferenciasAval.getEditText().setText("");
                        tlGarantiasAval.getEditText().setText("");

                        aval_id = "";
                        cliente_id = "";
                        ruta_id = "";
                        poblacion_id = "";
                        colocadora_id = "";
                        lat = "";
                        lgt = "";
                        btnUbicacion.setText("OBTENER UBICACIÓN");

                        pathsGarantiasCliente.clear();
                        pathsComprobantesCliente.clear();

                        pathsGarantiasAval.clear();
                        pathsComprobantesAval.clear();

                        NavOptions navOptions = new NavOptions.Builder()
                                .setPopUpTo(R.id.nav_clientes, true)
                                .build();

                        Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_clientes, null, navOptions);
                    }
                } else {
                    try {
                        String errorBody = response.errorBody().string();
                        // Verifica si el error es un JSON válido
                        if (errorBody.startsWith("{")) {
                            JSONObject jObjError = new JSONObject(errorBody);
                            new MaterialAlertDialogBuilder(getActivity())
                                    .setTitle("Aviso")
                                    .setMessage(jObjError.getString("message"))
                                    .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialogInterface, int i) {
                                        }
                                    })
                                    .show();
                        } else {
                            // Si no es un JSON, simplemente muestra el mensaje tal cual
                            new MaterialAlertDialogBuilder(getActivity())
                                    .setTitle("Aviso")
                                    .setMessage(errorBody)
                                    .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialogInterface, int i) {
                                        }
                                    })
                                    .show();
                        }
                    } catch (Exception e) {
                        Toast.makeText(requireActivity(), e.getMessage(), Toast.LENGTH_LONG).show();
                    }
                }
            }
            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: "+t.getLocalizedMessage() + " | " + t.getMessage());
                if(t.getLocalizedMessage().contains("Unable to resolve host")){
                    //Toast.makeText(getActivity(), "Se perdio la conexión, se guardo el cliente en local", Toast.LENGTH_LONG).show();

                    // Crear un MaterialAlertDialog personalizado
                    LayoutInflater inflater = getLayoutInflater();
                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                    // Encuentra el TextView y asigna el texto dinámico
                    TextView messageText = dialogView.findViewById(R.id.message_text);
                    messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getActivity());
                    builder.setView(dialogView); // Usa el layout personalizado

                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();

                    // Cerrar automáticamente el diálogo después de 3 segundos
                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);

                    registrarAvalEnSQLite(archivosGeneral, nombreAvalFormateado, direccionAval, telefonoAval, orAval, garantiasAval, ruta_id, poblacion_id, colocadora_id, cantidadGarantiasAval, cantidadArchivosAval, "", "off");

                    if (!clienteExisteEnSQLite(nombreFormateado)) {
                        registrarClienteEnSQLite(archivosGeneral, nombreFormateado, direccion, telefono, orCliente, garantias, ruta_id, poblacion_id, colocadora_id, cantidadGarantias, cantidadArchivos, "", "", "off");
                    }

                    String tipo="InsertCliente";
                    Log.d("SQLite", "Valor Id AVAL PARA Solicitud de subida: " + aval_id);
                    SolicitudSubida solicitud = new SolicitudSubida(archivosGeneral,nombre, direccion, telefono, orCliente, garantias, ruta_id, poblacion_id, colocadora_id, cantidadGarantias, cantidadArchivos,tipo,"",aval_id);
                    colaSolicitudes.agregarSolicitud(solicitud);

                    SolicitudSubida solicitud2 = new SolicitudSubida(archivosGeneral,nombreAval, direccionAval, telefonoAval, orAval, garantiasAval, ruta_id, poblacion_id, colocadora_id, cantidadGarantiasAval, cantidadArchivosAval,"InsertAval",cliente_id,"");
                    colaSolicitudes.agregarSolicitud(solicitud2);

                    tlNombreCliente.getEditText().setText("");
                    tlTelefono.getEditText().setText("");
                    tlDireccion.getEditText().setText("");
                    rutasAutoCompleteTextView.setText("");
                    poblacionesAutoCompleteTextView.setText("");
                    colocadorasAutoCompleteTextView.setText("");
                    tlOtrasReferencias.getEditText().setText("");
                    tlGarantias.getEditText().setText("");

                    cliente_id = "";
                    ruta_id = "";
                    poblacion_id = "";
                    colocadora_id = "";

                    pathsGarantiasCliente.clear();
                    pathsComprobantesCliente.clear();
                    NavOptions navOptions = new NavOptions.Builder()
                            .setPopUpTo(R.id.nav_clientes, true)
                            .build();

                    Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_clientes, null, navOptions);
                }
            }
        });
    }
    public boolean clienteExisteEnSQLite(String nombre) {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM clientes WHERE nombre_completo = ?", new String[]{nombre});
        cursor.moveToFirst();
        int count = cursor.getInt(0);
        cursor.close();
        return count > 0;
    }

    public boolean avalExisteEnSQLite(String nombre) {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM avales WHERE nombre_completo = ?", new String[]{nombre});
        cursor.moveToFirst();
        int count = cursor.getInt(0);
        cursor.close();
        return count > 0;
    }

    private void registrarClienteEnSQLite(List<MultipartBody.Part> archivosGeneral2, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String rutaId, String poblacionId, String colocadoraId, String cantidadGarantias, String cantidadArchivos, String clienteIdR, String avalIdR, String on) {
        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Verificar si el nombre del cliente ya existe
        if (verificarClienteExistente(db, nombre)) {
            Log.d("SQLite", "El cliente con nombre " + nombre + " ya existe en la base de datos.");
            Toast.makeText(requireContext(), "El cliente con este nombre ya existe.", Toast.LENGTH_LONG).show();
            db.close();
            return;
        }
        Log.d("SQLite", "ANTES D EENTRAR EN avalIdR..................." + avalIdR + " / " + aval_id);
        if (avalIdR.isEmpty()) {
            Log.d("SQLite", "ENTRO EN avalIdR..................." + avalIdR + " / " + aval_id);
            avalIdR=aval_id;
        }

        if(!clienteIdR.isEmpty())
        {
            cliente_id = clienteIdR;
            Log.d("SQLite", "ENTRO EN clienteIdR..................." + clienteIdR + " / " + cliente_id);
        }
        else
        {
            Log.d("SQLite", "El cliente con nombre " + nombre + " ya existe en la base de datos.");
            // Obtener el siguiente ID disponible
            cliente_id = String.valueOf(obtenerSiguienteIdCliente(db));
            Log.d("SQLite", "ENTRO EN ELSE........................ clienteIdR" + clienteIdR + " / " + cliente_id);
        }
        Log.d("SQLite", "Valores recibidos para inserción: rutaId=" + rutaId + ", poblacionId=" + poblacionId);
        Log.d("SQLite", "VALR DE CLIENTE PARA AVAL_ID LIGADO MODO OFFLINE " + avalIdR + " / " + avalIdR);
        // Crear el ContentValues para insertar el cliente
        ContentValues valores = new ContentValues();
        valores.put("id", cliente_id); // Asignamos el nuevo ID
        valores.put("nombre_completo", nombre);
        valores.put("direccion", direccion);
        valores.put("telefono", telefono);
        valores.put("otras_referencias", otrasReferencias);
        valores.put("garantias", garantias);
        valores.put("ruta_id", rutaId != null && !rutaId.isEmpty() ? rutaId : null);
        valores.put("poblacion_id", poblacionId != null && !poblacionId.isEmpty() ? poblacionId : null);
        valores.put("colocadora_id", colocadora_id);
        valores.put("aval_id", avalIdR);
        Calendar calendar = Calendar.getInstance();

        // Restar 10 minutos
        calendar.add(Calendar.MINUTE, -10);

        // Obtener la nueva fecha después de restar los 10 minutos
        Date nuevaFecha = calendar.getTime();

        // Formatear la fecha en el formato que necesitas (yyyy-MM-dd HH:mm:ss)
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String fechaRestada = dateFormat.format(nuevaFecha);

        // Ahora puedes guardar la fecha restada en la base de datos
        valores.put("created_at", fechaRestada);
        valores.put("updated_at", fechaRestada);

        valores.put("prestanombre", "0"); // Fecha de creación

        // Insertar el nuevo cliente en la base de datos
        long resultado = db.insert("clientes", null, valores);

        if (resultado != -1) {
            Log.d("SQLite", "Cliente registrado con éxito en SQLite con ID: " + cliente_id);
        } else {
            Log.d("SQLite", "Error al registrar el cliente en SQLite.");
        }

        db.close(); // Cerrar la conexión a la base de datos
    }

    // Método para verificar si un cliente con el mismo nombre ya existe en la base de datos
    private boolean verificarClienteExistente(SQLiteDatabase db, String nombre) {
        String query = "SELECT COUNT(*) FROM clientes WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        boolean existe = false;

        if (cursor.moveToFirst()) {
            existe = cursor.getInt(0) > 0;
        }
        cursor.close();

        return existe;
    }

    // Método para obtener el siguiente ID disponible en la tabla clientes
    private int obtenerSiguienteIdCliente(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM clientes", null);

        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();

        return ultimoId + 1;
    }

    private void registrarAvalEnSQLite(List<MultipartBody.Part> archivosGeneral2, String nombre, String direccion, String telefono,
                                       String otrasReferencias, String garantias, String rutaId, String poblacionId,
                                       String colocadoraId, String cantidadGarantias, String cantidadArchivos,
                                       String idServer, String online) {
        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Verificar si el aval ya existe en la base de datos
        String query = "SELECT id FROM avales WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        Calendar calendar = Calendar.getInstance();

        // Restar 10 minutos
        calendar.add(Calendar.MINUTE, -5);

        // Obtener la nueva fecha después de restar los 10 minutos
        Date nuevaFecha = calendar.getTime();

        // Formatear la fecha en el formato que necesitas (yyyy-MM-dd HH:mm:ss)
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String fechaRestada = dateFormat.format(nuevaFecha);
        if (cursor.moveToFirst()) {
            // El aval existe, obtenemos su ID
            aval_id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
            Log.d("SQLite", "El aval ya existe en SQLite con ID: " + aval_id);

            // Actualizar el registro existente
            ContentValues valores = new ContentValues();
            valores.put("direccion", direccion);
            valores.put("telefono", telefono);
            valores.put("otras_referencias", otrasReferencias);
            valores.put("garantias", garantias);
            valores.put("ruta_id", rutaId);
            valores.put("poblacion_id", poblacionId);
            valores.put("colocadora_id", colocadoraId);
            valores.put("updated_at", fechaRestada);

            int filasAfectadas = db.update("avales", valores, "id = ?", new String[]{aval_id});

            if (filasAfectadas > 0) {
                Log.d("SQLite", "Aval actualizado con éxito en SQLite con ID: " + aval_id);
            } else {
                Log.d("SQLite", "Error al actualizar el aval en SQLite.");
            }

        } else {
            // El aval no existe, insertar uno nuevo
            if (!online.equals("off")) {
                Log.d("SQLite", "ENTRO EN TOMAR ID EN LÍNEA");
                aval_id = idServer;
            } else {
                Log.d("SQLite", "ENTRO EN TOMAR ID SIN CONEXIÓN");
                aval_id = String.valueOf(obtenerSiguienteIdAval(db));
            }

            // Crear el ContentValues para insertar el nuevo aval
            ContentValues valores = new ContentValues();
            valores.put("id", aval_id);
            valores.put("nombre_completo", nombre);
            valores.put("direccion", direccion);
            valores.put("telefono", telefono);
            valores.put("otras_referencias", otrasReferencias);
            valores.put("garantias", garantias);
            valores.put("ruta_id", rutaId);
            valores.put("poblacion_id", poblacionId);
            valores.put("colocadora_id", colocadoraId);


            // Ahora puedes guardar la fecha restada en la base de datos
            valores.put("created_at", fechaRestada);
            valores.put("updated_at", fechaRestada);

            long resultado = db.insert("avales", null, valores);

            if (resultado != -1) {
                Log.d("SQLite", "Aval registrado con éxito en SQLite con ID: " + aval_id);
            } else {
                Log.d("SQLite", "Error al registrar el aval en SQLite.");
            }
        }

        // Cerrar cursor y base de datos
        cursor.close();
        db.close();
    }


    // Método para verificar si un cliente con el mismo nombre ya existe en la base de datos
    private boolean verificarAvalExistente(SQLiteDatabase db, String nombre) {
        String query = "SELECT COUNT(*) FROM avales WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        boolean existe = false;

        if (cursor.moveToFirst()) {
            existe = cursor.getInt(0) > 0;
        }
        cursor.close();

        return existe;
    }

    // Método para obtener el siguiente ID disponible en la tabla clientes
    // Método para obtener el siguiente ID disponible en la tabla clientes
    private int obtenerSiguienteIdAval(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = null;

        try {
            Log.d("SQLite", "Ejecutando consulta para obtener el máximo ID en la tabla 'avales'");
            cursor = db.rawQuery("SELECT MAX(id) FROM avales", null);

            if (cursor != null && cursor.moveToFirst()) {
                ultimoId = cursor.getInt(0);
                Log.d("SQLite", "Último ID obtenido de la tabla 'avales': " + ultimoId);
            } else {
                Log.w("SQLite", "Cursor está vacío o no contiene datos al consultar MAX(id)");
            }
        } catch (Exception e) {
            Log.e("SQLite", "Error al obtener el siguiente ID disponible en 'avales': " + e.getMessage(), e);
        } finally {
            if (cursor != null) {
                cursor.close();
                Log.d("SQLite", "Cursor cerrado después de consultar MAX(id) en 'avales'");
            }
        }

        int siguienteId = ultimoId + 1;
        Log.d("SQLite", "Siguiente ID calculado para la tabla 'avales': " + siguienteId);
        return siguienteId;
    }

}
